USE [Elerium]
GO

/****** Object:  StoredProcedure [dbo].[RP_ExpirePoints3YearsOld]    Script Date: 10/2/2013 5:13:51 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		<James Davis>
-- Create date: <2013-09-11>
-- Description:	<runs once a month on last day of month and expires users points that are older than 3 years>
-- =============================================
ALTER PROCEDURE [dbo].[RP_ExpirePoints3YearsOld] 
--@errorMessage varchar(2048) OUTPUT 
AS

DECLARE @currentTotalPoints money, @pastThreeYearEarnedPoints money, @possiblePointsToExpire money, @returnCode int = 1, @date3YearsAgo date, @cursorUserID int

BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	-- SET XACT_ABORT ON will cause the transaction to be uncommittable when the constraint violation occurs. 
	SET XACT_ABORT ON;

    BEGIN TRY
	BEGIN TRANSACTION;

	-- get the date three years ago
	SELECT @date3YearsAgo = DATEADD(year,-3, GETUTCDATE());

	DECLARE user_cur CURSOR FOR
		SELECT Distinct userID 
		FROM [dbo].[RewardTransaction] 
		OPEN user_cur
		FETCH NEXT FROM user_cur
		INTO @cursorUserID
		WHILE @@FETCH_STATUS = 0
		BEGIN
			
			-- get user total points for user
			SELECT @currentTotalPoints = ISNULL((SELECT SUM(PointChange) 
									FROM [dbo].[RewardTransaction] 
									WHERE UserID = @cursorUserID),0.0);

			-- sum past three years gained points for user
			SELECT @pastThreeYearEarnedPoints = ISNULL((SELECT SUM(rt3Y.PointChange) 
											FROM [dbo].[RewardTransaction] rt3Y 
											WHERE rt3Y.UserID = @cursorUserID and rt3Y.DateCreated > @date3YearsAgo and [Type] in (1,3,4,6,9)),0.0);
			
			
			-- get possible point to expire, only if @currentTotalPoints - @pastThreeYearPoints  is postive, if it is negative them there are no points to expire
			IF @currentTotalPoints - @pastThreeYearEarnedPoints > 0
				SELECT @possiblePointsToExpire = @currentTotalPoints - @pastThreeYearEarnedPoints;
			ELSE
				SELECT @possiblePointsToExpire = 0;

			-- if positive then user has points that are expiring so negate the number and record it in transaction as expired points
			IF @possiblePointsToExpire > 0
			BEGIN
				-- if points to expire for some crazy reason get to be more than total points then just expire all time points if over zero
				IF @currentTotalPoints - @possiblePointsToExpire >= 0
				BEGIN
					SET @possiblePointsToExpire = @possiblePointsToExpire * (-1);
						INSERT INTO [dbo].RewardTransaction
						(UserID
						,DateCreated
						,PointChange
						,[Type])
						VALUES
						(@cursorUserID
						,GETUTCDATE()
						,@possiblePointsToExpire
						,7)
				END
				ELSE IF @currentTotalPoints >= 0
				BEGIN 
					SET @possiblePointsToExpire = @currentTotalPoints * (-1);
						INSERT INTO [dbo].RewardTransaction
						(UserID
						,DateCreated
						,PointChange
						,[Type])
						VALUES
						(@cursorUserID
						,GETUTCDATE()
						,@possiblePointsToExpire
						,7)
				END
			END

			
			FETCH NEXT FROM user_cur INTO @cursorUserID
		END
		CLOSE user_cur
		DEALLOCATE user_cur

	COMMIT TRANSACTION;
	END TRY
	BEGIN CATCH
		ROLLBACK TRANSACTION;
		SELECT @returnCode = 3;
		--PRINT ERROR_MESSAGE();
		--SELECT @errorMessage = ERROR_MESSAGE();
		RETURN @returnCode
	END CATCH;
	RETURN @returnCode
END


GO


